package gov.va.vamf.scheduling.varutility.resource;

import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.service.CustomMessageService;
import gov.va.vamf.scheduling.varutility.service.CustomTextFormService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.Iterator;

@Component
@Path("/custom-text-form")
@Scope("request")
public class CustomTextFormResource implements InitializingBean {
    @Value("${default.messages.id}")
    String defaultMessagesId;

    @Value("${default.messages.text}")
    String defaultMessagesText;

    private String[] defaultMessageIds;
    private String[] defaultMessageTexts;

    @Autowired
    private CustomTextFormService customTextFormService;

    @Autowired
    private CustomMessageService customMessageService;

    @Override
    public void afterPropertiesSet() throws Exception {
        defaultMessageIds = defaultMessagesId.split("\\|");
        defaultMessageTexts = defaultMessagesText.split("\\|");
    }

    @GET
    @Path("/default-custom-friendly-text/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomFriendlyText fetchDCustomFriendlyText(@PathParam("site-code") String siteCode) {

        CustomFriendlyText foundCustomFriendlyText = customTextFormService.fetchCustomFriendlyTextBySiteCode(siteCode);

        if (foundCustomFriendlyText == null) {
            foundCustomFriendlyText = new CustomFriendlyText();
        }

        return foundCustomFriendlyText;
    }

    @GET
    @Path("/default-message/message-id/{message-id}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessage fetchDefaultMessage(@PathParam("message-id") String messageId) {

        CustomMessage defaultMessage = new CustomMessage();

        if (messageId != null) {
            for (int i = 0; i < defaultMessageIds.length; i++) {
                if (messageId.equals(defaultMessageIds[i])) {
                    defaultMessage.setMessageId(defaultMessageIds[i]);
                    defaultMessage.setMessageText(defaultMessageTexts[i]);
                    break;
                }
            }
        }

        return defaultMessage;
    }

    @PUT
    @Path("/custom-friendly-text/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomFriendlyText saveCustomFriendlyText(CustomFriendlyText customFriendlyText,
                                             @PathParam("site-code") String siteCode) {

        CustomFriendlyText foundCustomFriendlyText = customTextFormService.fetchCustomFriendlyTextBySiteCode(siteCode);
        CustomFriendlyText newCustomFriendlyText = new CustomFriendlyText();

        if (foundCustomFriendlyText != null && foundCustomFriendlyText.getId() != null) {
            newCustomFriendlyText.setId(foundCustomFriendlyText.getId());
        }

        newCustomFriendlyText.setSiteCode(siteCode);
        newCustomFriendlyText.setFriendlyText(customFriendlyText.getFriendlyText());

        CustomFriendlyText savedCustomFriendlyText = customTextFormService.saveCustomFriendlyText(newCustomFriendlyText);

        if (savedCustomFriendlyText == null) {
            savedCustomFriendlyText = new CustomFriendlyText();
        }

        return  savedCustomFriendlyText;

    }

    @DELETE
    @Path("/custom-messages/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessages deleteCustomMessages(@PathParam("site-code") String siteCode) {

        CustomMessages customMessages = customMessageService.deleteCustomMessagesBySiteCode(siteCode);

        if (customMessages == null) {
            customMessages = new CustomMessages();
        }

        return customMessages;
    }

    @DELETE
    @Path("/custom-friendly-text/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomFriendlyTexts deleteCustomFriendlyText(@PathParam("site-code") String siteCode) {

        CustomFriendlyTexts deletedCustomFriendlyTexts = customTextFormService.deleteCustomFriendlyTextBySiteCode(siteCode);

        if (deletedCustomFriendlyTexts == null) {
            deletedCustomFriendlyTexts = new CustomFriendlyTexts();
        }
        return deletedCustomFriendlyTexts;
    }

    @GET
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomTextForm fetchCustomTextForm(@PathParam("site-code") String siteCode) {

        CustomFriendlyText customFriendlyText = customTextFormService.fetchCustomFriendlyTextBySiteCode(siteCode);

        if (customFriendlyText == null) {
            customFriendlyText = new CustomFriendlyText();
        }

        CustomMessages customMessages = customMessageService.fetchCustomMessagesBySiteCode(siteCode);

        if (customMessages == null) {
            customMessages = new CustomMessages();
        }

        for (int i = 0; i < defaultMessageIds.length; i++) {
            if (!containsMessageId(defaultMessageIds[i], customMessages)) {

                CustomMessage defaultMessage = new CustomMessage();
                defaultMessage.setSiteCode(siteCode);
                defaultMessage.setMessageId(defaultMessageIds[i]);
                defaultMessage.setMessageText(defaultMessageTexts[i]);

                CustomMessage savedDefaultMessage = customMessageService.saveCustomMessage(defaultMessage);

                if (savedDefaultMessage != null) {
                    customMessages.add(savedDefaultMessage);
                }
            }
        }

        CustomTextForm customTextForm = new CustomTextForm();
        customTextForm.setSiteCode(siteCode);
        customTextForm.setUserFriendlyText(customFriendlyText.getFriendlyText());
        customTextForm.setCustomMessages(customMessages);

        return customTextForm;
    }

    @PUT
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomTextForm saveCustomTextForm(CustomTextForm customTextForm,
                                             @PathParam("site-code") String siteCode) {

        if (customTextForm == null) {
            customTextForm = new CustomTextForm();
        }

        CustomFriendlyText newCustomFriendlyText = new CustomFriendlyText();
        CustomFriendlyText customFriendlyText = null;

        if (customTextForm.getUserFriendlyText() == null) {
            CustomFriendlyTexts deletedCustomFriendlyTexts = customTextFormService.deleteCustomFriendlyTextBySiteCode(siteCode);

            if (deletedCustomFriendlyTexts != null && deletedCustomFriendlyTexts.size() > 0) {
                customFriendlyText = deletedCustomFriendlyTexts.get(0);
            }
        }
        else {
            CustomFriendlyText foundCustomFriendlyText = customTextFormService.fetchCustomFriendlyTextBySiteCode(siteCode);

            if (foundCustomFriendlyText != null && foundCustomFriendlyText.getId() != null) {
                newCustomFriendlyText.setId(foundCustomFriendlyText.getId());
            }

            newCustomFriendlyText.setSiteCode(siteCode);
            newCustomFriendlyText.setFriendlyText(customTextForm.getUserFriendlyText());

            customFriendlyText = customTextFormService.saveCustomFriendlyText(newCustomFriendlyText);
        }

        if (customFriendlyText == null) {
            customFriendlyText = new CustomFriendlyText();
        }

        CustomMessages customMessages = customTextForm.getCustomMessages();

        if(customMessages == null) {
            customMessages = new CustomMessages();
        }

        CustomMessages savedCustomMessages = new CustomMessages();

        CustomMessage foundCustomMessage = null;
        CustomMessage newCustomMessage = null;
        CustomMessage savedCustomMessage = null;

        Iterator<CustomMessage> customMessagesIterator = customMessages.iterator();

        while (customMessagesIterator.hasNext()) {
            newCustomMessage = customMessagesIterator.next();

            foundCustomMessage = customMessageService.fetchCustomMessageBySiteCodeAndMessageId(siteCode, newCustomMessage.getMessageId());

            if (foundCustomMessage != null && foundCustomMessage.getId() != null) {
                newCustomMessage.setId(foundCustomMessage.getId());
            }

            newCustomMessage.setSiteCode(siteCode);
            savedCustomMessage = customMessageService.saveCustomMessage(newCustomMessage);

            if (savedCustomMessage != null) {
                savedCustomMessages.add(savedCustomMessage);
            }
        }

        CustomTextForm savedCustomTextform = new CustomTextForm();
        savedCustomTextform.setSiteCode(siteCode);
        savedCustomTextform.setUserFriendlyText(customFriendlyText.getFriendlyText());
        savedCustomTextform.setCustomMessages(savedCustomMessages);

        return savedCustomTextform;
    }

    @DELETE
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomTextForm deleteCustomTextForm(@PathParam("site-code") String siteCode) {

        CustomFriendlyTexts deletedCustomFriendlyTexts = customTextFormService.deleteCustomFriendlyTextBySiteCode(siteCode);
        CustomFriendlyText deletedCustomFriendlyText = null;

        if (deletedCustomFriendlyTexts != null && deletedCustomFriendlyTexts.size() > 0) {
            deletedCustomFriendlyText = deletedCustomFriendlyTexts.get(0);
        }

        if (deletedCustomFriendlyText == null) {
            deletedCustomFriendlyText = new CustomFriendlyText();
        }

        CustomMessages deletetedCustomMessages = customMessageService.deleteCustomMessagesBySiteCode(siteCode);

        if (deletetedCustomMessages == null) {
            deletetedCustomMessages = new CustomMessages();
        }

        CustomTextForm deletedCustomTextform = new CustomTextForm();
        deletedCustomTextform.setSiteCode(siteCode);
        deletedCustomTextform.setUserFriendlyText(deletedCustomFriendlyText.getFriendlyText());
        deletedCustomTextform.setCustomMessages(deletetedCustomMessages);

        return deletedCustomTextform;
    }

    private boolean containsMessageId(String messageId, CustomMessages customMessages) {
        Iterator<CustomMessage> customMessagesIterator = customMessages.iterator();

        while (customMessagesIterator.hasNext()) {
            if (messageId.equals(customMessagesIterator.next().getMessageId())) {
                return true;
            }
        }

        return false;
    }
}

